#! /usr/bin/env python
import random
import time
import subprocess
import RPi.GPIO as GPIO
from bx1200ctrl import BX1200Ctrl


dial_frequencies = {160: 1.8366,
                    80: 3.5686,
                    40: 7.0386,
                    30: 10.1387,
                    20: 14.0956,
                    17: 18.1046,
                    15: 21.0946,
                    12: 24.9246,
                    10: 28.1246}


band_to_power = {160:20,
          80:20,
          40:20,
          30:20,
          20:10,
          17:17,
          15:17,
          12:17,
          10:17}

# LPF should use a 74HCT138  and a 74HC373 demultiplexer because 7,8,9,10,11 is set to input from wispberrypi
# this for an  u02 lpf originally designed for  limasdr 

def set_lpf(f):
   """
   BIT 0 = GPIO7
   BIT 1 = GPIO8
   BIt 3 = GPI24
   LATCH = GPIO 25 
   """
   _lpf = [0, 2e6, 4e6, 8e6, 15e6, 22e6, 30e5]
   for i in range(1, len(_lpf)):
     if f > _lpf[i-1] and f <= _lpf[i]:
        pos = i - 1
        b0 =  pos & 1 != 0
        b1 =  pos & 2 != 0
        b2 =  pos  & 4 != 0
        GPIO.output(24, GPIO.LOW)
        GPIO.output(7, GPIO.HIGH if b0 else GPIO.LOW)
        GPIO.output(8, GPIO.HIGH if b1 else GPIO.LOW)
        GPIO.output(25, GPIO.HIGH if b2 else GPIO.LOW)
        GPIO.output(24, GPIO.HIGH)
        time.sleep(0.01)
        GPIO.output(24, GPIO.LOW)
        print "GPIO set band :%s  for f %s" % (pos, f)
        break 
   return i


def init_lpf_gpio():
    GPIO.setmode(GPIO.BCM)
    for p in [7, 8, 24, 25]:
      GPIO.setup(p, GPIO.OUT)


def set_lpf_old(band):
    """
    """
    global low_pass_filter
    pins = set(low_pass_filter.values())
    band_pin = low_pass_filter[band]
    print "Setting GPIO pin %s for band %s" %(band_pin, band)
    for p in pins:
      GPIO.output(p, GPIO.LOW if p != band_pin else GPIO.HIGH)


def get_tx_frequency(band, offset_from_center):
   """
   """
   global dial_frequencies
   if abs(offset_from_center) <= 100:
      dialf = dial_frequencies[band]*1.0e6
      txf = dialf + 1500.0 + offset_from_center
      return txf
   else:
     raise ValueError("Offset to big")

   
def run_wspr(comport, call, locator, offset, bands, randomrange=None):
  """
  bands is list of bands to transmit on
  randomrange is a tupel (min, max) for a pause between 
  repeating the band list
  """
  global band_to_power
  bx_ctrl = BX1200Ctrl(comport)
  bx_ctrl.connect()
  number_of_bands = len(bands)
  init_lpf_gpio()
  print "Press CTRL C to end"
  try:
    while(True):
      if randomrange is not None:
           pause = random.randrange(randomrange[0], randomrange[1])
      else:
           pause = 0
      b_cnt = 0
      for band in bands:
          f = get_tx_frequency(band, offset)
          bx_ctrl.set_freqency(f)
          set_lpf(f)
          power = band_to_power[band]
          cmdline = ["./wspr", "-s", call, locator, "%s" % power, "%s" % f]
          b_cnt += 1
          if b_cnt == number_of_bands:
             cmdline.extend(["0" for i in range(pause)])  
          print cmdline
          # raw_input("wait ...")
          subprocess.call(cmdline)
          GPIO.cleanup()
          init_lpf_gpio()  # needs re init after running ./wspr
          # time.sleep(5) 
  except KeyboardInterrupt:
     pass         
  GPIO.cleanup()    
    

if __name__ == "__main__":

  bands = [20, 40, 80]
  run_wspr("/dev/ttyUSB0", "!your callsign!", "!your locator!", -55.0, bands, (1,4))	
